#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <time.h>

char* newString(size_t size)
{
    return (char*)malloc(size*sizeof(char));
}

char* multiplyBySingleDigit(const char* longNum, size_t longNumSize, char singleDigit)
{
    int index;

    char carry = 0;

    char* result = newString(longNumSize + 2);
    result[longNumSize + 1] = '\0';

    for(index = longNumSize - 1; index >= 0; --index)
    {
        char currentResult = (longNum[index] - '0') * (singleDigit - '0');
        currentResult += carry;

        carry = currentResult/10;
        result[index + 1] = (currentResult % 10) + '0';
    }

    if(carry > 0)
        result[0] = carry + '0';
    else
        memmove(result, result + 1, longNumSize + 1);
    
    return result;
}

void splitAt(const char* toSplit, size_t wholeLength, size_t lastCharsCount, char** lhsResult, const char** rhsResult)
{
    size_t firstCharsCount = wholeLength - lastCharsCount;

    *rhsResult = toSplit + firstCharsCount;
    *lhsResult = newString(firstCharsCount + 1);

    memcpy(*lhsResult, toSplit, firstCharsCount);

    (*lhsResult)[firstCharsCount] = '\0';
}

char* sum(const char* lhs, const char* rhs)
{
    size_t sizeLhs = strlen(lhs);
    size_t sizeRhs = strlen(rhs);

    size_t largerSize = sizeLhs > sizeRhs ? sizeLhs : sizeRhs;
    
    char carry = 0;

    int lhsIndex = sizeLhs - 1;
    int rhsIndex = sizeRhs - 1;
    int resultIndex = largerSize;

    char* result = newString(largerSize + 2);
    result[largerSize + 1] = '\0';

    while(lhsIndex >= 0 || rhsIndex >= 0)
    {
        char current = (lhsIndex >= 0 ? lhs[lhsIndex] - '0' : 0) + (rhsIndex >= 0 ? rhs[rhsIndex] - '0' : 0) + carry;

        result[resultIndex] = (current % 10) + '0';

        carry = current / 10;

        --lhsIndex;
        --rhsIndex;
        --resultIndex;
    }

    if(carry > 0)
        result[0] = carry + '0';
    else
        memmove(result, result + 1, largerSize + 1);

    return result;
}

char* subtract(const char* lhs, const char* rhs)
{
    size_t sizeLhs = strlen(lhs);
    size_t sizeRhs = strlen(rhs);
    
    size_t largerSize = sizeLhs > sizeRhs ? sizeLhs : sizeRhs;

    char carry = 0;

    int lhsIndex = sizeLhs - 1;
    int rhsIndex = sizeRhs - 1;
    
    int resultIndex = largerSize - 1;

    char* result = newString(largerSize + 1);
    result[largerSize] = '\0';

    while(lhsIndex >= 0 || rhsIndex >= 0)
    {
        char current = (lhsIndex >= 0 ? lhs[lhsIndex] - '0' : 0) - (rhsIndex >= 0 ? rhs[rhsIndex] - '0' : 0) - carry;

        if(current < 0)
        {
            current += 10;
            carry = 1;
        }
        else
        {
            carry = 0;
        }

        result[resultIndex] = current + '0';

        --lhsIndex;
        --rhsIndex;
        --resultIndex;
    }

    return result;
}

void multiplyByPow10(char** operand, size_t power)
{
    size_t sizeOperand = strlen(*operand);

    char* result = newString(sizeOperand + power + 1);
    
    memcpy(result, *operand, sizeOperand);
    memset(result + sizeOperand, '0', power);
    result[sizeOperand + power] = '\0';

    *operand = result;
}

char* multKaratsuba(const char* lhs, const char* rhs)
{
    size_t sizeLhs = strlen(lhs);
    size_t sizeRhs = strlen(rhs);

    size_t halfSize = (sizeLhs < sizeRhs ? sizeLhs : sizeRhs) / 2;

    char* lhsHigh, *rhsHigh;
    const char* lhsLow, *rhsLow;

    char* highProduct;
    char* lowProduct;
    char* sumLhs;
    char* sumRhs;
    char* sumProduct;
    char* sumHighLow;
    char* diffProduct;
    char* sumHighDiff;
    char* result;

    if(sizeLhs == 1 || sizeRhs == 1)
    {
        if(sizeLhs > sizeRhs)
            return multiplyBySingleDigit(lhs, sizeLhs, rhs[0]);

        return multiplyBySingleDigit(rhs, sizeRhs, lhs[0]);
    }

    splitAt(lhs, sizeLhs, halfSize, &lhsHigh, &lhsLow);
    splitAt(rhs, sizeRhs, halfSize, &rhsHigh, &rhsLow);

    highProduct = multKaratsuba(lhsHigh, rhsHigh);
    lowProduct =  multKaratsuba(lhsLow, rhsLow);

    sumLhs = sum(lhsHigh, lhsLow);
    sumRhs = sum(rhsHigh, rhsLow);
    
    sumProduct =  multKaratsuba(sumLhs, sumRhs);

    sumHighLow = sum(highProduct, lowProduct);

    diffProduct = subtract(sumProduct, sumHighLow);

    multiplyByPow10(&highProduct, halfSize * 2);
    multiplyByPow10(&diffProduct, halfSize);

    sumHighDiff = sum(highProduct, diffProduct);

    result = sum(sumHighDiff, lowProduct);

    free(sumHighDiff);
    free(diffProduct);
    free(sumHighLow);
    free(sumProduct);
    free(sumRhs);
    free(sumLhs);
    free(lowProduct);
    free(highProduct);
    free(rhsHigh);
    free(lhsHigh);

    return result;
}

char* newRandString(size_t size)
{
    size_t index;
    char* result = newString(size + 1);

    result[0] = (rand() % 9) + '0';

    for (index = 1; index < size; ++index)
        result[index] = (rand() % 10) + '0';
    
    result[size] = '\0';
    
    return result;
}

char* readLine(void)
{
    size_t inputSize = 100;
    char *input = newString(inputSize);
    size_t index = 0;

    char inputChar = 0;

    do
    {
        if(index == inputSize)
        {
            inputSize *= 2;
            input = (char*)realloc(input, inputSize * sizeof(char));
        }
        
        inputChar = getchar();
        
        input[index] = inputChar;
        
        ++index;
        
    } while (inputChar != '\n');
    
    input[index - 1] = '\0';

    return input;
}

int getTwoStringsAndMultiply(void)
{
    char* str1 = readLine();
    if (str1[0] == 0)
    {
        free(str1);
        return 0;
    }
    else
    {
        char* str2 = readLine();
        if (str2[0] == 0)
        {
            free(str2);
            free(str1);
            return 0;
        }
        else
        {
            char* result = multKaratsuba(str1, str2);
            printf("%s", result);
            free(result);
            free(str2);
            free(str1);
            return 1;
        }
    }
}

void testMeanRunningTimes(void)
{
    size_t size;
    size_t runsCount = 500;

    srand(time(0));

    for(size = 2; size <= 9; ++size)
    {
        size_t run;
        time_t totalTime = 0;

        for(run = 1; run <= runsCount; ++run)
        {
            char* num1 = newRandString(size * 100);
            char* num2 = newRandString(size * 100);
            
            time_t begin = time(0);
            
            char* result = multKaratsuba(num1, num2);
            
            time_t end = time(0);
            
            totalTime += (end - begin);

            free(result);
            free(num2);
            free(num1);
        }
        
        printf("%lu\t%lu\n", size*100, (totalTime * 1000)/runsCount);
    }
}

int main(void)
{
    if (!getTwoStringsAndMultiply())
        testMeanRunningTimes();

    return 0;
}