import jwt from "jsonwebtoken";
import express, { NextFunction, Request, Response } from "express";

const JWT_KEY = process.env.JWT_SECRET || "123456";

export function authenticateJWT(
  req: Request,
  res: Response,
  next: NextFunction
) {
  const authHeader = req.headers.authorization;
  if (authHeader && authHeader !== "null") {
    const token = authHeader.split(" ")[1];
    jwt.verify(token, JWT_KEY, (err: any, user: any) => {
      if (err) {
        return res
          .status(403)
          .send({ success: false, message: "Token Expired" });
      }
      // req.user = user;
      next();
    });
  } else {
    res.status(403).json({ success: false, message: "UnAuthorized" });
  }
}
