import express, { Request, Response, Router } from "express";

export const bookRouteName = "/book";

export default function routeBook() {
  const router = Router();

  type Book = {
    id?: string;
    createdAt?: number;
    title: string;
    author: string;
    finished: boolean;
  };

  const harryPotterAndThePhilosophersStone: Book = {
    id: "0",
    title: "Harry Potter and the Philosopher's Stone",
    author: "J. K. Rowling",
    finished: true,
  };

  const books = [harryPotterAndThePhilosophersStone];

  router.get("/books/", (req: Request, res: Response) => {
    res.json({ books });
  });

  router.get("/books/:id", (req: Request, res: Response) => {
    const book = books.find((book) => book.id === req.params.id);
    if (!book) {
      return res.status(404).json({ message: "Book not found" });
    }
    res.json({ book });
  });

  function createNewBook({
    title,
    author,
    finished,
  }: Pick<Book, "title" | "author" | "finished">): Book {
    // automatically create an id, use uuid or let the db generate one
    return {
      id: Math.random().toString(),
      title,
      author,
      finished,
      createdAt: Date.now(),
    };
  }

  function saveItToTheDatabase(book: Book) {
    return true;
  }

  router.post("/books", (req: Request, res: Response) => {
    // create a new book and save it to the database
    const book = createNewBook(req.body);
    if (!book) {
      return res.status(400).send();
    }
    const saved = saveItToTheDatabase(book);
    if (!saved) {
      return res.status(400).send();
    }
    res.json({ book });
  });

  return router;
}
