import { Response } from "express";
import { Send, Query } from "express-serve-static-core";
import { RequestWithUserId } from "./Request";

// This is only to ensure correct typing, no validation happens here
// For validation use express-validator or some other library
export interface TypedRequestBody<T> extends RequestWithUserId {
  body: T;
}

export interface TypedRequestQuery<T extends Query> extends RequestWithUserId {
  query: T;
}

export interface TypedRequest<T extends Query, U> extends RequestWithUserId {
  body: U;
  query: T;
}

export interface TypedResponse<ResBody> extends Response {
  json: Send<ResBody, this>;
}
