#define DOCTEST_CONFIG_IMPLEMENT
#include "doctest.h"
#include <vector>

template <typename T>
struct TNode
{
    T data;
    std::vector<TNode*> children;
};

/*
     РЕШЕНИЕ НА ЗАДАЧАТА
*/
template <typename T>
bool ordered_levels (TNode<T> *root);

TEST_CASE("Test Edges")
{
    CHECK_NOTHROW(ordered_levels<int>(nullptr));
}

TEST_CASE("Test")
{
    TNode<int> *t1 = new TNode<int> {0,{
                                     new TNode<int> {1,{
                                                     new TNode<int>{-1,{}},
                                                     new TNode<int>{1,{}}
                                     }},
                                     new TNode<int> {2,{
                                                     new TNode<int>{5,{
                                                                    new TNode<int>{7,{}},
                                                                    new TNode<int>{8,{}}
                                                     }}
                                     }},
                                     new TNode<int> {3,{}}
                     }};

    CHECK(ordered_levels(t1)==true);

    TNode<int> *t2 = new TNode<int> {0,{
                                     new TNode<int> {1,{
                                                     new TNode<int>{-1,{}},
                                                     new TNode<int>{1,{}}
                                     }},
                                     new TNode<int> {4,{
                                                     new TNode<int>{5,{
                                                                    new TNode<int>{7,{}},
                                                                    new TNode<int>{8,{}}
                                                     }}
                                     }},
                                     new TNode<int> {3,{}}
                     }};

    CHECK(ordered_levels(t2)==false);

    TNode<int> *t3 = new TNode<int> {0,{
                                     new TNode<int> {1,{
                                                     new TNode<int>{-1,{}},
                                                     new TNode<int>{1,{}}
                                     }},
                                     new TNode<int> {2,{
                                                     new TNode<int>{0,{
                                                                    new TNode<int>{7,{}},
                                                                    new TNode<int>{8,{}}
                                                     }}
                                     }},
                                     new TNode<int> {3,{}}
                     }};

    CHECK(ordered_levels(t3)==false);

    TNode<int> *t4 = new TNode<int> {0,{
                                     new TNode<int> {1,{
                                                     new TNode<int>{-1,{}},
                                                     new TNode<int>{1,{}}
                                     }},
                                     new TNode<int> {2,{
                                                     new TNode<int>{5,{
                                                                    new TNode<int>{8,{}},
                                                                    new TNode<int>{7,{}}
                                                     }}
                                     }},
                                     new TNode<int> {3,{}}
                     }};

    CHECK(ordered_levels(t4)==false);

}
int main()
{
    doctest::Context().run();
}