#define DOCTEST_CONFIG_IMPLEMENT
#include "doctest.h"
#include <queue>
#include <string>

struct TNode
{
    std::pair<std::string,int> data;
    TNode *left, *right;
};

/*
     РЕШЕНИЕ НА ЗАДАЧАТА
*/
TNode* create_tree(const std::string& s);

/*

    Помощна функция за тестовете.
    
    По зададена опашка с двойки (дума, брой срещания), проверява дали
    реда на елементите в опашката е същия, който се получава при обхождане 
    на дървото в ред ляво-корен-дясно. 
    
    Премахва се всеки елемент на опашката,
    който не нарушава този ред. Ако опашката остане непразна, 
    условието или не е изпълнено, или в опашката е ималко повече елементи,
    отколкото в дървото
*/
bool check_tree_order(TNode *root, 
                      std::queue<std::pair<std::string,int>>& pairs)
{
    if (root == nullptr)
    {
        return true;
    }
    if (pairs.size() == 0)
    {
        return false;
    }
    if (!check_tree_order(root->left,pairs))
    {
        return false;
    }
    if (pairs.front() != root->data)
    {
        return false;
    }
    pairs.pop();

    return check_tree_order(root->right,pairs);
}

TEST_CASE("Test Edges")
{
    CHECK_NOTHROW(create_tree(""));
    CHECK(create_tree("")==nullptr);
}

TEST_CASE("Test")
{
    std::queue<std::pair<std::string,int>> pairs_1({{"are",1},
                                                    {"counting",1},
                                                    {"for",1},
                                                    {"in",1},
                                                    {"only",1},
                                                    {"text",2},
                                                    {"this",1},
                                                    {"words",5}});

    const char* text = "text for counting words "
                       "only words are in this text words words words";



    CHECK(check_tree_order(create_tree(text),pairs_1)==true);
    CHECK(pairs_1.size() == 0);
}
int main()
{
    doctest::Context().run();
}