"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticateJWT = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const JWT_KEY = process.env.JWT_SECRET || "123456";
function authenticateJWT(req, res, next) {
    const authHeader = req.headers.authorization;
    if (authHeader && authHeader !== "null") {
        const token = authHeader.split(" ")[1];
        jsonwebtoken_1.default.verify(token, JWT_KEY, (err, user) => {
            if (err) {
                return res
                    .status(403)
                    .send({ success: false, message: "Token Expired" });
            }
            // req.user = user;
            next();
        });
    }
    else {
        res.status(403).json({ success: false, message: "UnAuthorized" });
    }
}
exports.authenticateJWT = authenticateJWT;
//# sourceMappingURL=index.js.map