"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importStar(require("express"));
const fs_1 = require("fs");
const multer_1 = __importDefault(require("multer"));
const path_1 = __importDefault(require("path"));
const swagger_jsdoc_1 = __importDefault(require("swagger-jsdoc"));
const swagger_ui_express_1 = __importDefault(require("swagger-ui-express"));
const routers_1 = __importDefault(require("./routers"));
const app = (0, express_1.default)();
const port = process.env.PORT || 8000;
const upload = (0, multer_1.default)();
app.use((0, express_1.urlencoded)({ extended: true }));
app.use(express_1.default.json());
function logMethod(req, res, next) {
    console.log("Request Type:", req.method);
    next();
}
app.use((req, res, next) => {
    console.log("Time:", Date.now());
    next();
});
app.use(logMethod);
app.get("/", (req, res) => {
    console.log(req.query);
    res.json(Object.assign({ name: "Express + TypeScript Server" }, req.query));
    // res.send("Express + TypeScript Server");
});
app.post("/", (req, res) => {
    console.log(req.body);
    res.json(Object.assign({}, req.body));
    // res.sendFile(path.join(__dirname, "htmlTemplates/index.html"));
});
app.post("/upload", upload.single("myFile"), (req, res) => {
    if (!req.file) {
        return res.status(401).json({ error: "Please provide an image" });
    }
    const imagePath = path_1.default.join(__dirname, `public/${req.file.originalname}`);
    (0, fs_1.createWriteStream)(imagePath).write(req.file.buffer);
    res.json({ path: `http://localhost:8000/media/${req.file.originalname}` });
    // res.redirect(`/media/${req.file.originalname}`);
});
app.use("/media", express_1.default.static("public"));
const options = {
    definition: {
        openapi: "3.0.0",
        info: {
            title: "Example Express API with Swagger",
            version: "0.1.0",
            description: "This is a simple CRUD API application made with Express and documented with Swagger",
            license: {
                name: "MIT",
                url: "https://spdx.org/licenses/MIT.html",
            },
            contact: {
                name: "Example",
                url: "https://ivanarabadzhiyski.com",
                email: "ivanarabadzhiyski@email.com",
            },
        },
        servers: [
            {
                url: "/",
            },
        ],
    },
    apis: ["./*.ts", "./*.js", "./*.yml", "./*.yaml"],
};
const swaggerDocument = (0, swagger_jsdoc_1.default)(options);
app.use("/api-docs", swagger_ui_express_1.default.serve, swagger_ui_express_1.default.setup(swaggerDocument));
const apiBaseUrl = (_a = process.env.API_BASE_URL) !== null && _a !== void 0 ? _a : "/";
app.use(apiBaseUrl, routers_1.default);
app.listen(port, () => {
    console.log(`⚡️[server]: Server is running at https://localhost:${port}`);
});
//# sourceMappingURL=index.js.map