"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bookRouteName = void 0;
const express_1 = require("express");
exports.bookRouteName = "/book";
function routeBook() {
    const router = (0, express_1.Router)();
    const harryPotterAndThePhilosophersStone = {
        id: "0",
        title: "Harry Potter and the Philosopher's Stone",
        author: "J. K. Rowling",
        finished: true,
    };
    const books = [harryPotterAndThePhilosophersStone];
    router.get("/books/", (req, res) => {
        // db request
        res.json({ books });
    });
    router.get("/books/:id", (req, res) => {
        const book = books.find((book) => book.id === req.params.id);
        if (!book) {
            return res.status(404).json({ message: "Book not found" });
        }
        res.json({ book });
    });
    function createNewBook({ title, author, finished, }) {
        // automatically create an id, use uuid or let the db generate one
        return {
            id: Math.random().toString(),
            title,
            author,
            finished,
            createdAt: Date.now(),
        };
    }
    function saveItToTheDatabase(book) {
        return true;
    }
    router.post("/books", (req, res) => {
        // create a new book and save it to the database
        const book = createNewBook(req.body);
        if (!book) {
            return res.status(400).send();
        }
        const saved = saveItToTheDatabase(book);
        if (!saved) {
            return res.status(400).send();
        }
        res.json({ book });
    });
    return router;
}
exports.default = routeBook;
//# sourceMappingURL=index.js.map