"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const http_status_codes_1 = __importDefault(require("http-status-codes"));
const Book_1 = __importDefault(require("../../models/Book"));
const router = express_1.Router();
// @route   GET api/books
// @desc    Get all books, pagination is enabled
// @access  Public
router.get("/", (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { page = "1", pageSize = "10" } = req.query;
        const pageNumber = Number(page);
        const pageSizeNumber = Number(pageSize);
        const books = yield Book_1.default.find()
            .skip((pageNumber - 1) * pageSizeNumber)
            .limit(pageSizeNumber);
        const total = yield Book_1.default.countDocuments();
        res.json({
            books,
            nextPage: pageNumber * pageSizeNumber < total ? pageNumber + 1 : null,
            total: total / pageSizeNumber,
        });
    }
    catch (err) {
        console.error(err.message);
        res.status(http_status_codes_1.default.NOT_FOUND).send("Server Error");
    }
}));
// @route   POST api/books
// @desc    Create or update books
// @access  Public
router.post("/", (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    // validate
    const { authorName, title } = req.body;
    const bookFields = {
        authorName,
        title,
    };
    try {
        const book = new Book_1.default(bookFields);
        yield book.save();
        res.json(book);
    }
    catch (err) {
        console.error(err.message);
        res.status(http_status_codes_1.default.INTERNAL_SERVER_ERROR).send("Server Error");
    }
}));
// @route   GET api/books/:bookId
// @desc    Get book by bookId
// @access  Public
router.get("/:bookId", (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const book = yield Book_1.default.findById(req.params.bookId);
        res.json(book);
    }
    catch (err) {
        console.error(err.message);
        if (err.kind === "ObjectId") {
            return res
                .status(http_status_codes_1.default.NOT_FOUND)
                .json({ msg: "Book not found" });
        }
        res.status(http_status_codes_1.default.INTERNAL_SERVER_ERROR).send("Server Error");
    }
}));
// @route   DELETE api/books/:bookId
// @desc    Delete books
// @access  Public
router.delete("/:bookId", (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        yield Book_1.default.findByIdAndRemove(req.params.bookId);
        res.json({ msg: "Book removed." });
    }
    catch (err) {
        console.error(err.message);
        res.status(http_status_codes_1.default.INTERNAL_SERVER_ERROR).send("Server Error");
    }
}));
exports.default = router;
//# sourceMappingURL=books.js.map