const TEXT_NODE = 3;

function printText(node) {
	if (node) {
		if (node.nodeType === TEXT_NODE){
			if (node.textContent.trim().length > 0) {
				console.log(node.textContent);
			}
		}

		const children = node.childNodes;
		for (const child of children) {
			printText(child);
		}
	}
}

function countByClass(node, className) {
	let count = 0;
	if (node) {
		if (node.className === className) {
			count = 1;
		}
		
		let child = node.firstChild;
		while (child) {
			count += countByClass(child, className);
			child = child.nextSibling;
		}
	}
	return count;
}

function findElementByID(node, id) {
	if (node) {
		if (node.id === id) {
			return node;
		}

		const children = node.childNodes;
		for (const child of children) {
			const result = findElementByID(child, id);
			if (result) {
				return result;
			}
		}
	}
	return null;
}

//checks if all ID-s are unique
function isCorrect(node, allIds) {
	var allIds = allIds || {};

	if (node) {
		if (node.id) {
			if (allIds[node.id]) {
				console.log(node.id);
				return false;
			}
			allIds[node.id] = true;
		}
		
		const children = node.childNodes;
		for (const child of children) {
			const result = isCorrect(child, allIds);
			if (!result) {
				return false;
			}
		}
	}
	return true;
}

function colorizeText(node, text, color) {
	if (!node) return;	
	const children = node.childNodes;
	
	for (const currentNode of children) {
		if (currentNode && currentNode.nodeType === TEXT_NODE) {
			const textPosition = currentNode.textContent.indexOf(text);
			if (textPosition < 0) {
				continue;
			}
			
			const firstPart = currentNode.textContent.substring(0, textPosition);
			const secondPart = currentNode.textContent.substring(textPosition + text.length);

			const newNode = document.createElement("span");
			newNode.style.color = color;
			newNode.textContent = text;

			const replaceNode = document.createElement("span");
			replaceNode.appendChild(document.createTextNode(firstPart));
			replaceNode.appendChild(newNode);
			replaceNode.appendChild(document.createTextNode(secondPart));

			node.replaceChild(replaceNode, currentNode);
		}
		else {
			colorizeText(currentNode, text, color);
		}
	}
}

//printText(document.body);
//console.log(countByClass(document, 'inner'));
//console.log(findElementByID(document.body, 'first-div-outer'))
//console.log(isCorrect(document, null));
//colorizeText(findElementByID(document.body, 'first-div-outer'), 'text', 'red');
