function getRandomInt(max) {
  return Math.floor(Math.random() * max);
}


function imgMouseOver(event) {
	event.target.style.color = 'DarkRed';
}


function imgMouseOut(event) {
	event.target.style.color = 'black';
}


function imgClick(event) {
	const colors = ['blue', 'green', 'red', 'yellow', 'grey', 'white'];
	
	//Опитайте какво става с event.target;
	const target = event.currentTarget;

	target.style.backgroundColor = colors[getRandomInt(colors.length)];
}


function createImageNode(data) {
	const node = document.createElement("div");
	node.className = "image-div";
/*	
	const img = document.createElement("img");
	img.className = "picture";
	img.alt = data.alt;
	img.src = data.source;
	node.appendChild(img);
	
	const par = document.createElement("p");
	par.className = "description";
	par.textContent = data.description;
	node.appendChild(par);
*/

	node.innerHTML = `
		<img src="${data.source}" alt="${data.alt}" class="picture">
		<p class="description">${data.description}</p>
`


	node.addEventListener('mouseover', imgMouseOver)
	node.addEventListener('mouseout', imgMouseOut)
	node.addEventListener('click', imgClick) //node.onClick(imgClick);
	return node;
}

function createGallery(root, data) {
	for (const dd of data){
//		console.log(dd)
		root.appendChild(createImageNode(dd))
	}
}


function hideLoader () {
	const loaderNode = document.getElementById('loader');
	loaderNode.parentElement.removeChild(loaderNode);
	//loaderNode.remove()
}


function loadImages() {
	hideLoader();
	
	const galeryNode = document.getElementById('main-gallery-grid');
	const imageData = loadImageArray()
	createGallery(galeryNode, imageData);
}
