import express, {
  Express,
  NextFunction,
  Request,
  Response,
  urlencoded,
} from "express";
import { createWriteStream } from "fs";
import multer from "multer";
import path from "path";
import swaggerJSDoc from "swagger-jsdoc";
import swaggerUi from "swagger-ui-express";
import api from "./routers";

const app = express();
const port = process.env.PORT || 8000;
const upload = multer();

app.use(urlencoded({ extended: true }));
app.use(express.json());

function logMethod(req: Request, res: Response, next: NextFunction) {
  console.log("Request Type:", req.method);
  next();
}

app.use((req, res, next) => {
  console.log("Time:", Date.now());
  next();
});

app.use(logMethod);

app.get("/", (req: Request, res: Response) => {
  console.log(req.query);
  res.json({ name: "Express + TypeScript Server", ...req.query });
  // res.send("Express + TypeScript Server");
});

app.post("/", (req: Request, res: Response) => {
  console.log(req.body);
  res.json({ ...req.body });
  // res.sendFile(path.join(__dirname, "htmlTemplates/index.html"));
});

app.post("/upload", upload.single("myFile"), (req: Request, res: Response) => {
  if (!req.file) {
    return res.status(401).json({ error: "Please provide an image" });
  }
  const imagePath = path.join(__dirname, `public/${req.file.originalname}`);
  createWriteStream(imagePath).write(req.file.buffer);
  res.json({ path: `http://localhost:8000/media/${req.file.originalname}` });
  // res.redirect(`/media/${req.file.originalname}`);
});

app.use("/media", express.static("public"));

const options = {
  definition: {
    openapi: "3.0.0",
    info: {
      title: "Example Express API with Swagger",
      version: "0.1.0",
      description:
        "This is a simple CRUD API application made with Express and documented with Swagger",
      license: {
        name: "MIT",
        url: "https://spdx.org/licenses/MIT.html",
      },
      contact: {
        name: "Example",
        url: "https://ivanarabadzhiyski.com",
        email: "ivanarabadzhiyski@email.com",
      },
    },
    servers: [
      {
        url: "/",
      },
    ],
  },
  apis: ["./*.ts", "./*.js", "./*.yml", "./*.yaml"],
};

const swaggerDocument = swaggerJSDoc(options);

app.use("/api-docs", swaggerUi.serve, swaggerUi.setup(swaggerDocument));

const apiBaseUrl = process.env.API_BASE_URL ?? "/";

app.use(apiBaseUrl, api);

app.listen(port, () => {
  console.log(`⚡️[server]: Server is running at https://localhost:${port}`);
});
