"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.auth = void 0;
const http_status_codes_1 = __importDefault(require("http-status-codes"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
function auth(req, res, next) {
    var _a;
    // Get token from header
    const token = req.header("x-auth-token");
    // Check if no token
    if (!token) {
        return res
            .status(http_status_codes_1.default.UNAUTHORIZED)
            .json({ msg: "No token, authorization denied" });
    }
    // Verify token
    try {
        const payload = jsonwebtoken_1.default.verify(token, (_a = process.env.JWT_SECRET) !== null && _a !== void 0 ? _a : "");
        req.userId = payload.userId;
        next();
    }
    catch (err) {
        res
            .status(http_status_codes_1.default.UNAUTHORIZED)
            .json({ msg: "Token is not valid" });
    }
}
exports.auth = auth;
//# sourceMappingURL=auth.js.map