import { Document, model, Schema } from "mongoose";

/**
 * Interface to model the Book Schema for TypeScript.
 * @param title:string
 * @param authorName:string
 */
export interface IBook extends Document {
  title: string;
  authorName: string;
}

const bookSchema = new Schema({
  title: {
    type: String,
    required: true,
  },
  authorName: {
    type: String,
    required: true,
  },
  date: {
    type: Date,
    default: Date.now,
  },
});

const Book = model("Books", bookSchema);

export default Book;
