import { connect } from "mongoose";

const connectDB = async () => {
  try {
    const mongoURI = process.env.MONGO_URI ?? "";
    const options = {
      useNewUrlParser: true,
      useCreateIndex: true,
      useFindAndModify: false,
      useUnifiedTopology: true,
    };
    await connect(mongoURI, options);
    console.log("MongoDB Connected...");
  } catch (err) {
    console.error((err as any).message);
    // Exit process with failure
    process.exit(1);
  }
};

export default connectDB;
