/*
 * triarea.cpp
 *
 *  Created on: 26.11.2013
 *      Author: trifon
 */

#include <cmath>
#include "triarea.h"

double square(double);

double triarea(double x1, double y1,
		       double x2, double y2,
		       double x3, double y3) {
	double a = distance(x1, y1, x2, y2);
	double b = distance(x1, y1, x3, y3);
	double c = distance(x2, y2, x3, y3);
	return heron(a, b, c);
}

double distance(double x1, double y1,
				double x2, double y2) {
	return sqrt(square(x1-x2)+square(y1-y2));
}

double heron(double a, double b, double c) {
	double p = (a + b + c) / 2;
	return sqrt(p*(p-a)*(p-b)*(p-c));
}
