#include <iostream>
#include <assert.h>

using namespace std;

const int ls = 8; //размер на дъската
int sol = 0; 	  //брой намерени до момента решения


void printLab (int lab[ls][ls])
{
	cout << "***************************"<<endl;
	for (int row = 0; row < ls; row++)
	{
		for (int col = 0; col < ls; col++)
		{
			cout << " " << lab[row][col] << " ";
			
		}
		cout << endl;
	}
	cout << "***************************"<<endl;
}

void markVisited (int lab[ls][ls], int row, int col)
{
	assert (lab[row][col]==false);
	lab[row][col] = 9;
}

bool canStepOn (int lab[ls][ls], int row, int col)
{
	return row >= 0 &&
	       col >= 0 && 
	       row < ls &&
	       col < ls &&
	       lab[row][col] == 0;
}

bool wayExists  (int lab[ls][ls], int startRow, int startCol)
{
	//тривиален път
	if (startRow == ls-1 && startCol == ls-1)
	{
		return true;
	}

	markVisited (lab,startRow,startCol);

	//надолу
	if (canStepOn (lab,startRow+1,startCol) && 
		wayExists (lab,startRow+1,startCol)){
		cout << "[" << startRow << "," << startCol << "]";
		return true;
	}
	//надясно
	if (canStepOn (lab,startRow,startCol+1) && 
		wayExists (lab,startRow,startCol+1)){
		cout << "[" << startRow << "," << startCol << "]";
		return true;
	}
	//нагоре
	if (canStepOn (lab,startRow-1,startCol) && 
		wayExists (lab,startRow-1,startCol)){
		cout << "[" << startRow << "," << startCol << "]";
		return true;
	}
	//налявно
	if (canStepOn (lab,startRow,startCol-1) && 
		wayExists (lab,startRow,startCol-1)){
		cout << "[" << startRow << "," << startCol << "]";
		return true;
	}

	//не е намерен път
	//в никоя посока
	return false;

}

int main ()
{

	int lab[ls][ls] = {0,1,0,0,0,0,0,0,
						0,1,0,0,0,0,0,0,
						0,1,0,0,0,0,0,0,
						0,1,0,0,0,0,0,0,
						0,0,0,0,0,0,0,0,
						0,0,1,0,0,0,0,0,
						0,0,1,0,0,0,0,0,
						0,0,2,0,0,0,0,0};


	printLab (lab);

	if (wayExists (lab,0,0))
	{
		cout << "Yes!" << endl;
	}

	printLab (lab);



	return 0;
}