#include <iostream>
#include <assert.h>

using namespace std;

const int bs = 8; //размер на дъската
int sol = 0; //брои намерените до момента решения


void printBoard(bool board[bs][bs])
{
	sol ++;
	cout << "[" << sol << "]" << "***************************"<<endl;
	for (int row = 0; row < bs; row++)
	{
		for (int col = 0; col < bs; col++)
		{
			if (board[row][col])
			{
				cout << " X ";
			} else {
				cout << " O ";
			}
		}
		cout << endl;
	}
	cout << "***************************"<<endl;
}

void placeQueen (bool board[bs][bs], int row, int col)
{
	assert (board[row][col]==false);
	board[row][col] = true;
}

void replaceQueen (bool board[bs][bs], int row, int col)
{
	assert (board[row][col]==true);
	board[row][col] = false;
}

bool canPlaceQueen (bool board[bs][bs], int row, int col)
{
	
	for (int count = 0; count < bs; count++)
	{
		if (board[row][count] || board[count][col])
			return false;
	}

	//диагонал
	//неравенства, от които произлиза този цикъл:
	//row+count > 0; row + count < 8; => count > -row; count < 8-row;
	//col+count > 0; col + count < 8;
	for (int count = -min(row,col); count < min (bs-row,bs-col);count++)
	{
		if (board[row+count][col+count])
			return false;
	}

	//обратен диагонал
	//неравенства, от които произлиза този цикъл:
	//row+count > 0; row + count < 8
	//col-count > 0; col - count < 8;
	for (int count = max(-row,col-bs); count < min (col,bs-row);count++)
	{
		if (board[row+count][col-count])
			return false;
	}


	return true;

}

void placeQuuens (bool board[bs][bs], int number)
{
	if (number == 0)
	{
		printBoard(board);
		return;
	}

	for (int row = 0; row < bs; row++)
	{
		for (int col = 0; col < bs; col++)
		{
			//ако е възмопжно, опитваме до поставим
			//царица на поаиция (row,col)
			if (canPlaceQueen (board,row,col))
			{
				placeQueen (board,row,col);
				//сега пробваме number - 1
				//царици на "остатъка" от
				//позициите: т.е. всички възможни конфигурации,
				//при които на (row,col) сме поставили
				//царица на този ход
				placeQuuens (board,number-1);
				//премахваме царицата, която току що
				//поставихме, за да може следващите 
				//итерации на цикъла да "пробват"
				//конфигурациите, при които на 
				//(row,col) няма царица
				replaceQueen (board,row,col);
			}

		}
	}

}

int main ()
{

	bool board[bs][bs] = {false};


	placeQuuens (board,bs);

	return 0;
}