#include <iostream>

using namespace std;


bool compareGt (int a, int b) {return a > b;}
bool compareLt (int a, int b) {return a < b;}


template <typename ElementType>
int findExtremum (ElementType arr[], 
				  int arrSize , 
				  bool (*pComparator)(ElementType,ElementType))
{
	int indexMax = 0;
	for (int i = 1; i < arrSize; i++)
		if (pComparator (arr[indexMax],arr[i])) indexMax = i;
	return indexMax; 
}

template <typename ElementType>
void sort (ElementType arr[], 
		   int arrSize, 
		   bool (*pComparator)(ElementType,ElementType))
{
	for (int i = 0; i < arrSize-1; i++) {
	//find subarray extremum and //swap with a[i]
		swap (arr[i], arr[i+findExtremum(arr+i, arrSize -i, pComparator )]);
	} 
}


struct Student
{
	int fn;
	double grade;

};


bool compareStudentByGrade (Student s1, Student s2)
{
	return s1.grade < s2.grade;
}

bool compareStudentByFn (Student s1, Student s2)
{
	return s1.fn < s2.fn;
}

int main ()
{

	Student s1, s2;
	s1.fn = 1;
	s1.grade = 6;
	s2.fn = 2;
	s2.grade = 5;

	Student studArr[] = {s1,s2};


	cout << "ix of best student=" 
		 << findExtremum<Student> (studArr,2,compareStudentByGrade) << endl;
	cout << "ix of student with least fn=" 
		 << findExtremum<Student> (studArr,2,compareStudentByFn) << endl;


	sort (studArr,2,compareStudentByFn);




	int arr[] = {1,7,3,5,2,3,0,4}; 
	
	cout << arr[findExtremum (arr,8,compareLt)] << endl;

	sort (arr,8,compareLt);
	cout << endl << arr[0] << endl;
	sort (arr,8,compareGt);
	cout << arr[0] << endl;

	return 0;
	
}