#include <iostream>
#include <assert.h>

using namespace std;


template <typename T>
using mapFn = T (*) (T);

template <typename ResT, typename ElemT>
using reduceFn = ResT (*) (ResT, ElemT);

template <typename T>
void map (T arr[], int arrsize, mapFn<T> f)
{
	for (int i = 0; i < arrsize; i++)
		arr[i] = f(arr[i]);
}

template <typename ResT,typename ElemT>
ResT reduce (ElemT arr[], int arrsize, reduceFn<ResT,ElemT> f, ResT init)
{
	ResT result = init;

	for (int i = 1; i < arrsize; i++)
		result = f (result,arr[i]);

	return result;

}


int main ()
{

	int arr[] = {1,2,3};

	//map<int> (arr,3,[](int a){return a+1;});

	//cout << reduce<int,int> (arr,3,[](int a, int b){return a+b;},0);

	cout << "*" << reduce<bool,int> (arr,3,[](bool a, int b){return a || b==2;},false);


	return 0;
}