#include <iostream>
#include <math.h>

using namespace std;

class Point
{
public:
	double x,y;
	Point ():x(0),y(0){}
	Point (double _x, double _y):x(_x),y(_y){}

};

class Figure
{
public:
	virtual double surface () = 0;
	virtual double perimeter () = 0;

	virtual ~Figure ()
	{cout << "~Figure \n";}
};


class Circle : public Figure
{
public:
	double r;
	Point center;

	double perimeter ()
	{
		return 2 * M_PI * r;
	}

	double surface ()
	{
		return M_PI * r * r;
	}

	Circle (double _r, Point _center): r (_r), center (_center){}

	~Circle ()
	{cout << "~Circle \n";}
};


class Square : public Figure
{

public:
	double side;
	Point center;
	double sideAngleTan;

	double perimeter ()
	{
		return side * 4;
	}

	double surface ()
	{
		return side * side;
	}

	Square (double _side, double _sideAngleTan, Point _center): side (_side), sideAngleTan (_sideAngleTan),center (_center){}

};


class Rectangle : public Figure{
public:
	double sidea,sideb;
	double sideaTan;
	Point center;

	Rectangle (double _sidea, double _sideb, double _sideaAngleTan, Point _center): sidea (_sidea), sideb (_sideb), sideaTan (_sideaAngleTan),center (_center){}

	double surface ()
	{
		return sidea * sideb;
	}

	double perimeter () {return 2*sidea + 2*sideb;}


};


double sumSurf (Figure* figures[], int n)
{
  double sum = 0;
  
  for (int i = 0; i < n; i++)
    sum += figures[i]->surface();

  return sum;
}

double sumPerim (Figure* figures[], int n)
{
  double sum = 0;
  
  for (int i = 0; i < n; i++)
    sum += figures[i]->perimeter();

  return sum;
}

int main ()
{

  Figure* figures[] = {
  	new Circle (2,Point (0,0)), 
    new Circle (4,Point(1,1)),
    new Square (2,0,Point(0,0)), 
    new Rectangle (2,3,0,Point(0,0)),
	new Square (4,0,Point(0,0)),
    new Square (3,0,Point(0,0))};


  //cout << figures[0]->surface() << endl; БЕЗ VIRTUAL
  //cout << figures[0]->surface() << endl;

  cout << "Total surface = " << sumSurf (figures,6) << endl;
  cout << "Total perimeter = " << sumPerim (figures,6) << endl;

  for (int i = 0; i < 6; i++)
  	delete figures[i];



}