#pragma once

#include <iostream>
using std::istream;
using std::ostream;

class Worker
{
public:
	static double hourSalary;
    static int counter;
	virtual void read(istream&) = 0;
	virtual void print (ostream & ) const = 0;

	virtual double calculateSalary() = 0;
	Worker()
    {
        Worker::counter = Worker::counter + 1;
    }
	friend istream& operator>>(istream & i, Worker& p)
	{
		p.read(i);
		return i;
	}

	friend ostream& operator<< (ostream & o, Worker const&  w)
	{
	    w.print(o);
	    return o;
	}
	virtual ~Worker()
	{
	    --counter;
	};
};

class PartTimeWorker :public Worker
{
	int hours;
public:
	double calculateSalary()
	{
		if (hours <= 40)
			return hours * Worker::hourSalary;
		else if (hours <= 60)
			return (40 + 1.5*(hours - 40))* Worker::hourSalary;
		else
			return (70 + (hours - 60))* Worker::hourSalary;
	}


	void read(istream& i)
	{
		std::cout << "I`m part time worker.\nHow much hours will I work?\n";
		i >> hours;
	}

	void print(ostream& o) const
	{
		o<< "I`m Part time worker.\n I`ve worked "<<hours <<" hours\n";
	}
};

class FullTimeWorker :public Worker
{
public:
	double calculateSalary()
	{
		return 40 * Worker::hourSalary;
	}
	void read(istream& i)
	{
		std::cout << "I`m full time employee and I will work 40 hours. You don`t have to set worktime for me.\n";
	}

	void print(ostream& o) const
	{
		o<< "I`m Full time worker.\n I`ve worked "<< 8 <<" hours\n";
	}

};
