#include <iostream>
#include "Point.h"

Point::Point(int x,int y, char *color)
{
	this->x=x;
	this->y=y;
	this->color = NULL;
	setColor(color);
}

void Point::setColor(const char *value)
{
	//if (color!=NULL)
		//delete color;
	color = new char[strlen(value+1)];
	strcpy(color,value);
}

const char* Point::getColor()
{
	return color;
}

int Point::getX()
{
	return x;
}
void Point::setX(int value)
{
	x = value;
}
int Point::getY()
{
	return y;
}
void Point::setY(int value)
{
	y = value;
}

Point& Point::operator = (Point& right)
{
	x = right.x;
	y = right.y;
	setColor(right.getColor());
	return *this;
}

Point::Point(Point& other)
{
	color = NULL;
	*this = other;
}
Point::~Point()
{
	if (color != NULL)
		delete color;
}
void Point::toJSON(char* json)
{
	strcat(json,"{");
	strcat(json,"x:");
	char *value = new char[8];
	ltoa(x,value,10);
	strcat(json,value);
	strcat(json,",");
	strcat(json,"y:");
	ltoa(y,value,10);
	strcat(json,value);
	strcat(json,",");
	strcat(json,"color:");
	strcat(json,color);
	strcat(json,",");
	strcat(json,"type:point");
	strcat(json,"}");
	delete [] value;
}

void Point::fromJSON(char *json)
{
	char *prop;
	if (json[0] == '{')
	{
		// it's an object
		// remove the last }
		json[strlen(json)-1] = 0;
		strcpy(json,json+1);
	}
	else
	{
		return;
	}
	prop = strtok (json,",");
	while (prop != NULL)
	{
		char *propName;
		char *propValue;
		char *idx = strstr(prop,":");
		propValue = idx+1;
		*idx = 0;
		propName = prop;
		if ((strcmp(propName,"type") == 0) &&
			(strcmp(propValue,"point") != 0))
		{
			// something wrong is going on....
		}
		else if (strcmp(propName,"x") == 0)		
		{
			setX(atol(propValue));
		}
		else if (strcmp(propName,"y") == 0)		
		{
			setY(atol(propValue));
		}
		else if (strcmp(propName,"color") == 0)
		{
			setColor(propValue);
		}
		prop = strtok (NULL, ",");
	}
}
