#include "generators.h"

using namespace std;

SumIntGenerator::SumIntGenerator(IntGenerator* lGenerator, IntGenerator* rGenerator) {
	leftIntGenerator = lGenerator->getCopy();
	rightIntGenerator = rGenerator->getCopy();
}

SumIntGenerator::SumIntGenerator(const SumIntGenerator& generator) {
	leftIntGenerator = generator.leftIntGenerator->getCopy();
	rightIntGenerator = generator.rightIntGenerator->getCopy();
}

SumIntGenerator& SumIntGenerator::operator=(const SumIntGenerator& generator) {
	if (this != &generator) {
		delete leftIntGenerator;
		delete rightIntGenerator;
		leftIntGenerator = generator.leftIntGenerator->getCopy();
		rightIntGenerator = generator.rightIntGenerator->getCopy();
	}
	return *this;
}


int SumIntGenerator::generate() {
	return leftIntGenerator->generate() + rightIntGenerator->generate();
}

IntGenerator* SumIntGenerator::getCopy() {
	IntGenerator *copy = new SumIntGenerator(*this);
	return copy;
}

SumIntGenerator::~SumIntGenerator() {
	delete leftIntGenerator;
	delete rightIntGenerator;
}

FibGenerator::FibGenerator() {
	currentValue = 1;
	nextFib = 1;
}

int FibGenerator::generate() {
	int returnValue = currentValue;
	currentValue = nextFib;
	nextFib = currentValue + returnValue;
	return returnValue;
}

IntGenerator* FibGenerator::getCopy() {
	IntGenerator *copy = new FibGenerator(*this);
	return copy;
}

NaturalGenerator::NaturalGenerator() {
	currentValue = 0;
}

int NaturalGenerator::generate() {
	return currentValue++;
}

IntGenerator* NaturalGenerator::getCopy() {
	IntGenerator* copy = new NaturalGenerator(*this);
	return copy;
}

EvenGenerator::EvenGenerator() {
	currentValue = 0;
}

int EvenGenerator::generate() {
	currentValue += 2;
	return currentValue;
}

IntGenerator* EvenGenerator::getCopy() {
	IntGenerator *copy = new EvenGenerator(*this);
	return copy;
}