#include <iostream>
#include <fstream>
#include "generators.h"
using namespace std;


class IntStream {
protected:
	IntGenerator* generator;
public:
	IntStream() {
		generator = new NaturalGenerator();
	}

	IntStream(IntStream& iStream) {
		generator = iStream.generator->getCopy();
	}

	IntStream& operator=(IntStream& iStream) {
		if (this != &iStream) {
			delete generator;
			generator = iStream.generator->getCopy();
		}
		return *this;
	}

	IntStream(IntGenerator& intGenerator) {
		generator = intGenerator.getCopy();
	}

	IntStream& operator >>(int &x) {
		x = generator->generate();
		return *this;
	}

	IntStream operator ^(IntStream& iStream) {
		SumIntGenerator sumGenerator = SumIntGenerator(this->generator, iStream.generator);
		IntStream sumStream(sumGenerator);
		return sumStream;
	}

	int operator +(IntStream& iStream) {
		return generator->generate() + iStream.generator->generate();
	}

	~IntStream() {
		delete generator;
	}
};

class EvenStream : public IntStream {
public:
	EvenStream() {
		generator = new EvenGenerator();
	}
};

class FibStream : public IntStream {
public:
	FibStream() {
		generator = new FibGenerator();
	}
};

void main() {
	EvenStream eStream;
	FibStream fStream;
	IntStream nStream;

	int x;
	eStream>>x>>x>>x;//2,4,6
	cout<<x<<endl;//x == 6
	fStream>>x>>x>>x>>x>>x>>x;//1,1,2,3,5,8
	cout<<x<<endl;//x == 8
	nStream>>x>>x>>x>>x;//0,1,2,3
	cout<<x<<endl;//x == 3
	cout<<nStream + fStream<<endl;//4+13=17
	IntStream efStream;
	efStream = eStream ^ fStream;
	efStream>>x;//x == 21 + 8
	cout<<x<<endl;
}