#ifndef GENERATORS_H_
#define GENERATORS_H_

#include <iostream>
using namespace std;

class IntGenerator {
protected:
	int currentValue;
public:
	virtual int generate() = 0;
	virtual IntGenerator* getCopy() = 0;
};

class SumIntGenerator : public IntGenerator {
	IntGenerator *leftIntGenerator;
	IntGenerator *rightIntGenerator;
public:
	SumIntGenerator(IntGenerator* lGenerator, IntGenerator* rGenerator);
	SumIntGenerator(const SumIntGenerator& generator);
	SumIntGenerator& operator=(const SumIntGenerator& generator);
	int generate();
	IntGenerator* getCopy();
	~SumIntGenerator();
};

class FibGenerator : public IntGenerator {
	int nextFib;
public:
	FibGenerator();
	int generate();
	IntGenerator* getCopy();
};

class NaturalGenerator : public IntGenerator {
public:
	NaturalGenerator();
	int generate();
	IntGenerator *getCopy();
};

class EvenGenerator : public IntGenerator {
public:
	EvenGenerator();
	int generate();
	IntGenerator* getCopy();
};

#endif /* GENERATORS_H_ */