#include <iostream>
#include <fstream>
#include <string>
#include <sstream>

#define MAX_DOCUMENT_CHARACTERS 300
#define MAX_SEARCH_TERM_CHARACTERS 200
#define MAX_TOKEN_COUNT 15
#define MAX_TOKEN_CHARACTERS_COUNT 20
#define MAX_SEARCH_RESULTS 20
#define MAX_DOCUMENTS_COUNT 1000
#define SIZEOF_DOCUMENT sizeof(char)*MAX_DOCUMENT_CHARACTERS
#define SIZEOF_INDEX_ENTRY sizeof(IndexEntry)

using namespace std;

struct IndexEntry {
	char token[MAX_TOKEN_CHARACTERS_COUNT];
	int indexes[MAX_DOCUMENTS_COUNT];
	int indexesCount;
	IndexEntry() {
		indexesCount = 0;
		strcpy(token,"");
	}
	IndexEntry(char _token[MAX_TOKEN_CHARACTERS_COUNT], int documentIndex) {
		strcpy(token, _token);
		indexes[0] = documentIndex;
		indexesCount = 1;
	}
};

void tokenize(const char *str, char* results[MAX_TOKEN_COUNT], int& resultsCount) {
	char* token = new char[MAX_TOKEN_CHARACTERS_COUNT];
	resultsCount = 0;
	istringstream iss(str);
	while ( iss>>token )
	{
		results[resultsCount] = new char[strlen(token) + 1];
		strcpy(results[resultsCount++], token);
	}
}
	
//intersects two sorted arrays
void intersect(const int* const leftArray, const int leftArraySize, const int* const rightArray, const int rightArraySize, int*& result, int& resultSize) {
	int li=0, ri=0, maxResultSize = min(leftArraySize, rightArraySize);
	result = new int[maxResultSize];
	resultSize = 0;
	while ((li<leftArraySize) && (ri<rightArraySize)) {
		if (leftArray[li] == rightArray[ri]) {
			result[resultSize++] = leftArray[li];
			ri++;
			li++;
		} else if (leftArray[li] > rightArray[ri]) {
			ri++;
		} else {
			li++;
		}
	}
}


class Database {
	char *dbFileName;
	char *indexFileName;
	void getDocument(int index, char* document) {
		int documentIndex = 0;
		ifstream fin(dbFileName,ios::binary);
		fin.seekg(SIZEOF_DOCUMENT*index, ios::beg);
		fin.read(document,SIZEOF_DOCUMENT);
		fin.close();
	}

	IndexEntry getIndexEntryForToken(char *token) {
		ifstream fin(indexFileName, ios::binary);
		fin.seekg(fin.beg);
		 
		IndexEntry indexEntry, indexEntryForToken;
		while (fin.read((char *)&indexEntry,SIZEOF_INDEX_ENTRY)) {
			if (strcmp(indexEntry.token, token) == 0) {
				indexEntryForToken = indexEntry;
				break;
			}
		}

		fin.close();
		return indexEntryForToken;
	}

	void updateIndex(const char* document, int documentIndex) {
		int tokensCount=0;
		char* tokens[MAX_TOKEN_COUNT];
		tokenize(document, tokens, tokensCount);

		IndexEntry indexEntry("empty",1);
		for (int i=0; i<tokensCount; i++) {
			bool tokenWillBeUpdated = false;
			ifstream indexFile(indexFileName, ios::binary);
			indexFile.clear();
			indexFile.seekg(ios::beg);
			int entryCount=0;

			while (indexFile.read((char*)&indexEntry, SIZEOF_INDEX_ENTRY)) {
				//if we find the token in the file, we will update the indexes
				if (strcmp(indexEntry.token,tokens[i]) == 0) {
					tokenWillBeUpdated = true;
					break;
				}
				entryCount++;
			}
			indexFile.close();

			if (!tokenWillBeUpdated) {
				//create new record in the index file
				IndexEntry newIndexEntry(tokens[i], documentIndex);
				ofstream fout(indexFileName, ios::binary | ios::ate | ios::app);
				fout.write((char*)&newIndexEntry, SIZEOF_INDEX_ENTRY);
				fout.close();
			} else {
				if (indexEntry.indexes[indexEntry.indexesCount-1] < documentIndex) {
					indexEntry.indexes[indexEntry.indexesCount++] = documentIndex;
				}
				ofstream fout(indexFileName, ios::binary | ios::in);
				fout.seekp(entryCount * SIZEOF_INDEX_ENTRY, 0);
				fout.write((char*)&indexEntry, SIZEOF_INDEX_ENTRY);
				fout.close();
			}
		}
	}

public:
	Database(const char* dbname) {
		dbFileName = new char[strlen(dbname)+5];
		indexFileName = new char[strlen(dbname)+8];
		strcpy(dbFileName, dbname);
		strcpy(indexFileName, dbname);
		strcat(dbFileName, ".dat");
		strcat(indexFileName, "idx.dat");
		//crating the files
		/*ofstream indexFile(indexFileName, ios::binary | ios::out), dbFile(dbFileName, ios::binary | ios::out);
		indexFile.close();
		dbFile.close();*/
	}

	void addDocument(const char* document) {
		int documentIndex = 0;
		
		ofstream fout(dbFileName,ios::binary | ios::app | ios::ate);
		int pPos = fout.tellp(), size = SIZEOF_DOCUMENT;
		documentIndex = pPos/size;
		fout.write((char *)document,SIZEOF_DOCUMENT);
		fout.close();

		updateIndex(document, documentIndex);
	}

	void search(char* searchTerm, char searchResults[][MAX_DOCUMENT_CHARACTERS], int& searchResultsCount) {
		int tokensCount=0;
		char* tokens[MAX_TOKEN_COUNT];
		tokenize(searchTerm, tokens, tokensCount);
		int *documentIndexes = NULL;
		int documentIndexesSize = 0;

		if (tokensCount == 1) {
			IndexEntry indexEntry = getIndexEntryForToken(tokens[0]);
			documentIndexes = indexEntry.indexes;
			documentIndexesSize = indexEntry.indexesCount;
		} else {
			IndexEntry indexEntry1 = getIndexEntryForToken(tokens[0]), indexEntry2 = getIndexEntryForToken(tokens[1]);
			intersect(indexEntry1.indexes, indexEntry1.indexesCount, indexEntry2.indexes, indexEntry2.indexesCount, documentIndexes, documentIndexesSize);
			int *helper = NULL, helperSize = 0;
			for (int i = 2; i < tokensCount; i++) {
				IndexEntry indexEntry = getIndexEntryForToken(tokens[i]);
				helper = NULL;
				helperSize = 0;
				intersect(indexEntry.indexes, indexEntry.indexesCount, documentIndexes, documentIndexesSize, helper, helperSize);
				delete documentIndexes;
				documentIndexes = new int[helperSize];
				for (int helperI = 0; helperI < helperSize; helperI++) {
					documentIndexes[helperI] = helper[helperI];
				}
				documentIndexesSize = helperSize;
			}
		}

		searchResultsCount = documentIndexesSize;
		for (int i=0; i<documentIndexesSize; i++) {
			char document[MAX_DOCUMENT_CHARACTERS];
			getDocument(documentIndexes[i], document);
			strcpy(searchResults[i], document);
		}
	}
};

void main() {
	Database db("sampledb");
	int choice = 0;
	char bulk;

	while (choice != 3) {
		cout<<"Choose:"<<endl;
		cout<<"1. Enter a document"<<endl;
		cout<<"2. Search"<<endl;
		cout<<"3. Exit"<<endl<<endl<<"Enter your choice: ";
		cin>>choice;
		cin.get(bulk);
		switch (choice) {
		case 1: {
					char document[MAX_DOCUMENT_CHARACTERS];
					cout<<endl<<"Enter your document: ";
					cin.getline(document,MAX_DOCUMENT_CHARACTERS, '\n');
					db.addDocument(document);
					cout<<endl;
				} break;
		case 2:{
					char searchTerm[MAX_SEARCH_TERM_CHARACTERS];
					cout<<endl<<"Enter your search term: ";
					cin.getline(searchTerm,MAX_SEARCH_TERM_CHARACTERS, '\n');

					char searchResults[MAX_SEARCH_RESULTS][MAX_DOCUMENT_CHARACTERS];
					int searchResultsCount = 0;

					db.search(searchTerm, searchResults, searchResultsCount);

					cout<<endl<<"***R E S U L T S***"<<endl<<endl;
					for (int i=0; i<searchResultsCount; i++) {
						cout<<i<<": "<<searchResults[i]<<endl;
					}
					cout<<endl<<"*******************"<<endl<<endl;
			   } break;

		}
	}
}