#include <iostream>
#include "stack.cpp"
#include <string>

using namespace std;

void transformRPN(char* expression, char* rpn) {
	int rpni = 0;
	LinkedStack<char> operators;
	while (*expression) {
		switch(*expression) {
		case ')': {
					char operatorSymbol = operators.pop();
					rpn[rpni++] = operatorSymbol;
				  } break;
		case '+':
		case '-':
		case '/':
		case '^':
		case '*': {
					operators.push(*expression);
				  } break;
		case '(': break;
		default: {
					rpn[rpni++] = *expression;
				 }
		}
		expression++;
	}
	rpn[rpni] = '\0';
}

void transformPN(char* expression, char* pn) {
	char rpn[100];
	char revExpression[100];
	strcpy(revExpression, expression);
	strrev(revExpression);
	char *expressionIter = revExpression;
	while (*expressionIter) {
		if (*expressionIter == ')') {
			*expressionIter = '(';
		} else if (*expressionIter == '(') {
			*expressionIter = ')';
		}
		expressionIter++;
	}
	transformRPN(revExpression, rpn);
	strrev(rpn);
	strcpy(pn, rpn);
}

void transformPN2(char* expression, char* pn) {
	LinkedStack<string> operands;
	LinkedStack<char> operators;
	while (*expression) {
		switch(*expression) {
		case ')': {
					char operatorSymbol = operators.pop();
					string rightOperand = operands.pop(),
						leftOperand = operands.pop();
					string operatorString(1, operatorSymbol);
					operatorString.append(leftOperand).append(rightOperand);
					operands.push(operatorString);
				  } break;
		case '+':
		case '-':
		case '/':
		case '^':
		case '*': {
					operators.push(*expression);
				  } break;
		case '(': break;
		default: {
					char operandChar = *expression;
					string operand(1, operandChar);
					operands.push(operand);
				 }
		}
		expression++;
	}
	string pnString = operands.pop();
	strcpy(pn, pnString.c_str());
}

void main() {

	char expression[100], rpn[100], pn[100];
	cout<<"Enter expression: ";
	cin>>expression;

	transformRPN(expression, rpn);
	cout<<"RPN: "<<rpn<<endl;
	transformPN(expression, pn);
	cout<<"PN: "<<pn<<endl;
	transformPN2(expression, pn);
	cout<<"PN2: "<<pn<<endl;
}