#include "LinkedStack.h"

template <typename T>
LinkedStack<T>::LinkedStack() {
	top = NULL;
}

template <typename T>
LinkedStack<T>::LinkedStack(LinkedStack<T> const& ls) {
	copy(ls);
}

template <typename T>
void LinkedStack<T>::copy(LinkedStack<T> const& ls) {
	/* !!!  !!!
	top = NULL;
	while(!ls.empty())
		push(ls.pop());
		*/
	if (ls.empty())
		top = NULL;
	else {
		//  
		top = new StackElement<T>;
		top->data = ls.top->data;

		//    
		StackElement<T>* toCopy = ls.top->next;
		StackElement<T>* lastCopy = top;

		while (toCopy != NULL) {
			// 
			StackElement<T>* newCopy = new StackElement<T>;
			newCopy->data = toCopy->data;

			// 
			lastCopy->next = newCopy;

			//    
			toCopy = toCopy->next;
			lastCopy = newCopy;
		}
		//  
		lastCopy->next = NULL;
	}
}

template <typename T>
bool LinkedStack<T>::empty() const {
	return top == NULL;
}

template <typename T>
bool LinkedStack<T>::push(T const& x) {
	StackElement<T>* el = new StackElement<T>;
	el->data = x;
	el->next = top;
	top = el;
	return true;
}

template <typename T>
T LinkedStack<T>::last() const {
	if (empty())
		return T();
	return top->data;
}

template <typename T>
T LinkedStack<T>::pop() {
	if (empty())
		return T();
	// top != NULL
	StackElement<T>* el = top;
	top = top->next;
	T x = el->data;
	delete el;
	return x;
}

template <typename T>
LinkedStack<T>::~LinkedStack() {
	clean();
}

template <typename T>
void LinkedStack<T>::clean() {
	// !!! delete top; //   !
	while (!empty())
		pop();
	//  :  
}

template <typename T>
LinkedStack<T>& LinkedStack<T>::operator =(LinkedStack<T> const& ls) {
	if (this != &ls) {
		clean();
		copy(ls);
	}
	return *this;
}