#pragma once

#include <string>
#include "Scope.h"
#include "ExpressionTransformer.cpp"

using namespace std;

/*
 2  ,    :
1.   /    
1.1. : <  >=<>
2.   
2.1. : <>=?
:
<> = < > || <> || (<><><>)
<> = + || - || * || /
<  > = {a,b,c,d,e,...,x,y,z} //  

     , ..     .   ,      
*/

namespace CommandExecutor {

	// -    
	static bool getAtomValue(char atom, Scope& scope, double& value) {
		if (atom >= '0' && atom <= '9') {
			value = atom - '0';
			return true;
		}
		if (atom >= 'a' && atom <= 'z') {
			return scope.getVariableValue(atom, value);
		}
		return false;
	};
	
	static bool evaluateExpression(string expression, Scope& scope, double& result, char* error) {

		char *rpn= new char[expression.length()+1];
		ExpressionTransformer::transformRPN(expression.c_str(), rpn);
		bool expressionIsValid = true;

		LinkedStack<double> stack;
		while (*rpn) {
			if ((*rpn >= '0' && *rpn <= '9') || (*rpn >= 'a' && *rpn<='z'))
			{
				double value;
				if (!getAtomValue(*rpn, scope, value)) {
					sprintf(error, "%c is undefined!", *rpn);
					expressionIsValid = false;
				}

				stack.push(value);

			} else {
				double r = stack.pop();
				double l = stack.pop();

				switch (*rpn) {
					case '+':stack.push(l + r);break;
					case '-':stack.push(l - r);break;
					case '*':stack.push(l * r);break;
					case '/':stack.push(l / r);break;
					default: {
						sprintf(error, "unsupported operator - %c!", *rpn);
						expressionIsValid = false;
					}
				}
			}
			if (!expressionIsValid) break;
			rpn++;
		}

		if (!expressionIsValid) {
			return false;
		}

		result = stack.pop();
		return true;
	}

	static bool executeCommand(string commandLine, Scope& scope, char*result, char* error) {
		if (commandLine.length() < 3) {
			strcpy(error,"I is not so smart, master :(\n I don't know what you want to do!");
			return false;
		}

		if ((commandLine[commandLine.length()-1] == '?') && (commandLine[commandLine.length()-2] == '=')) {
			//   (<>=?)
			string expression = commandLine.substr(0, commandLine.length() - 2);
			double resultValue = 0.0f;
			bool success = evaluateExpression(expression, scope, resultValue, error);
			if (success) {
				char resultValueString[10];
				sprintf_s(resultValueString, 10, "%f", resultValue);
				strcpy(result, expression.append("=").append(resultValueString).c_str());
			}

			return success;
		} else if (commandLine[1] == '=') {
			//  /     (<  >=<>)

			if (commandLine[0] < 'a' || commandLine[0] > 'z') {
				//  -     ,    
				sprintf(error, "%c is not a valid variable name", commandLine[0]);
				return false;
			}

			string expression = commandLine.substr(2, commandLine.length()-1);
			double resultValue = 0.0f;
			bool success = evaluateExpression(expression, scope, resultValue, error);

			if (success) {
				scope.setVariableValue(commandLine[0],resultValue);
				strcpy(result, "SUCCESS!!! Your variable is now set!");
			}

			return success;
		}
		
		strcpy(error,"I is not so smart, master :(\n I don't know what you want to do!");

		return false;
	};
}