#pragma once

#include "LinkedStack.cpp"
#include <string>

using namespace std;

namespace ExpressionTransformer
{
	static void transformRPN(const char* expression, char* rpn) {
		int rpni = 0;
		LinkedStack<char> operators;
		while (*expression) {
			switch(*expression) {
			case ')': {
						char operatorSymbol = operators.pop();
						rpn[rpni++] = operatorSymbol;
					  } break;
			case '+':
			case '-':
			case '/':
			case '^':
			case '*': {
						operators.push(*expression);
					  } break;
			case '(': break;
			default: {
						rpn[rpni++] = *expression;
					 }
			}
			expression++;
		}
		rpn[rpni] = '\0';
	}

};

