#pragma once
#include <cstddef>

using namespace std;

template <typename T>
struct StackElement {
	T data;
	StackElement* next;
};

template <typename T>
class LinkedStack {
protected:
	StackElement<T>* top;
			  //   , ..  
			  //     
public:

	LinkedStack(); // create
	LinkedStack(LinkedStack const&);

	//     
	bool empty() const;

	//    
	bool push(T const&);

	//   
	T pop();

	//     
	T last() const;

	// 
	~LinkedStack();

	//   
	LinkedStack& operator=(LinkedStack const&);

private:

	// 
	void copy(LinkedStack const&);

	// 
	void clean();
};

