#include "DParser.h"
#include <cstddef>
#include <iostream>
using namespace std;

DParser::DParser(string fileName)
	:input(fileName)
{
	for(int i=0; i < NUM_LETTERS; i++)
	{
		variables[i] = NULL;
	}
}

DParser::~DParser()
{
	for(int i=0; i < NUM_LETTERS; i++)
	{
		if(variables[i]!=NULL)
			delete variables[i];
	}
}

void DParser::parseLine(string line)
{
	stringstream strstr(line);

	string current;
	strstr >> current;

	if(current[0] >= 'a' && current[0] <= 'z')
	{
		if (!parseAssignment(strstr, current[0])) {
			//14.11.2014  substr(1,line.length()-1),           
			cout<<"Error executing the assignment: \""<<line.substr(1,line.length()-1)<<'"'<<endl;
		}
	} else if(current[0] == '$') {
		parseAndExecuteCommand(strstr,current,cout);
	} else {
		parseDeclaration(strstr,current);
	}

}

void DParser::execute()
{
	while(getline(input,currentLine,'!'))
	{
		parseLine(currentLine);
	}
}

bool DParser::parseDeclaration(stringstream& strstr, string type)
{
	char varName;
	strstr >> varName;
	if(variables[varName-'a']!=NULL)
	{
		cerr <<"Already defined variable! ";
		return false;
	}

	char c;
	strstr >> c;

	string expr;
	strstr >> expr;
	bool declaredTypeIsNum = (type == "Number");
	bool assignedValueIsNum;
	Var* varValue = parseValue(expr,assignedValueIsNum);
	if(declaredTypeIsNum!=assignedValueIsNum)
	{
		cerr << "Type mismatch!" << endl;
		return false;
	}
	variables[varName-'a'] = varValue;
	return true;
}

bool DParser::parseAssignment(stringstream& strstr, char varName)
{
	if (variables[varName - 'a'] == NULL) {
		return false;
	}

	char c;
	strstr >> c;
	if(c!='=')
	{
		return false;
	}

	string expr;
	strstr >> expr;
	
	bool isNum = isNumber(varName);
	bool isNumValue;
	Var* varValue = parseValue(expr,isNumValue);
	if(isNum!=isNumValue)
	{
		cerr << "Type mismatch!" << endl;
		return false;
	}
	if(variables[varName-'a']!=NULL)
	{
		delete variables[varName-'a'];
	}
	variables[varName-'a'] = varValue;
	return true;
}

Var* DParser::parseValue(string str, bool& isNumValue)
{
	if(str[0] == '"')
	{
		StrVar* var = new StrVar();
		//       
		var->setValue(str.substr(1,str.length()-2).c_str());
		isNumValue = false;
		return var;
	}
	else
	{
		NumVar* var = new NumVar();
		var->setValue(str.c_str());
		isNumValue = true;
		return var;
	}
}

bool DParser::isNumber(char c)
{
	return variables[c-'a']->isNum();
}

bool DParser::parseAndExecuteCommand(stringstream& str,string command, ostream& os)
{
	if(command == "$print")
	{
		string expr;
		str >> expr;
		string output = parseExpression(expr);

		os << output << endl;
		return true;
	}
	return false;
}

string DParser::parseExpression(string expression)
{
	if(expression[0] >= 'a' && expression[0] <= 'z')
	{
		return variables[expression[0]-'a']->toString();
	} else if(expression[0] == '(') {
		char c;
		stringstream ss;
		ss << expression;
		ss >> c;
		char firstVar, secondVar;
		ss >> firstVar;
		ss >> c;
		if(c!='+') 
			return "Error!";
		ss >> secondVar;
		return variables[firstVar-'a']->add(variables[secondVar-'a']);
	} else {
		bool gbg;
		return parseValue(expression,gbg)->toString();
	}
}