#include <iostream>
#include <stack>
#include <string>
#include <vector>
#include <algorithm>
#include "Application.h"
using namespace std;

#define neighbours vector<int>

/*
Implements the DFS algorithm on a graph
*/

class DFSApp : public Application {
public:
	void run() {
		vector<neighbours> graph;
		neighbours n1, n2, n3, n4, n5;
		n1.push_back(2);

		n2.push_back(1);
		n2.push_back(3);
		n2.push_back(4);

		n3.push_back(2);
		n3.push_back(5);

		n4.push_back(2);
		n4.push_back(5);

		n5.push_back(3);
		n5.push_back(4);

		graph.push_back(n1);
		graph.push_back(n2);
		graph.push_back(n3);
		graph.push_back(n4);
		graph.push_back(n5);

		printDFSResult(graph, 2);
	}
private:
	struct PathVertex {
		int value;
		string prefix;
		PathVertex(int _value, string _prefix) {
			value = _value;
			prefix = _prefix;
		}
		operator int() const {
			return value;
		}
	};

	void printDFSResult(vector<neighbours> graph, int startingNode) {
		vector<int> discoveredNodes;
		stack<PathVertex> currentPath;
		string prefix = "";
		currentPath.push(PathVertex(startingNode, prefix));
		while(!currentPath.empty()) {
			PathVertex currentNode = currentPath.top();
			currentPath.pop();
			if (find(discoveredNodes.begin(), discoveredNodes.end(), currentNode) == discoveredNodes.end()) {
				//not yet discovered
				cout<<currentNode.prefix<<currentNode.value<<endl;
				prefix.append("-");
				discoveredNodes.push_back(currentNode.value);

				for (unsigned i = 0; i < graph[currentNode.value-1].size(); i++) {
					if (find(discoveredNodes.begin(), discoveredNodes.end(), graph[currentNode.value-1][i]) == discoveredNodes.end()) {
						currentPath.push(PathVertex(graph[currentNode.value-1][i], prefix));
					}
				}
			} else {
				prefix = prefix.substr(0,prefix.size()-1);
			}

		}
	}
};