#include <iostream>
#include <queue>
#include <string>
#include "Application.h"
using namespace std;

/*
Solves the Josephus problem(http://en.wikipedia.org/wiki/Josephus_problem)
*/

class JosephusApp : public Application {
public:
	void run() {
		int numPeople = 0, passes = 0;
		cout<<"Enter number of people: ";
		cin>>numPeople;
		cout<<"Enter number of passes: ";
		cin>>passes;
		if (!numPeople || !passes) {
			cout<<"No one was killed - today was a good day!"<<endl;
		} else {
			queue<int> eliminationOrder;
			int jNumber = getJosephusNumber(numPeople, passes, eliminationOrder);
			cout<<"People got killed in the following order: "<<endl;
			while (!eliminationOrder.empty()) {
				int person = eliminationOrder.front();
				eliminationOrder.pop();
				cout<<person<<" ";
			}

			cout<<endl<<"Joseph must sit at position "<<jNumber<<endl;
		}
	}
private:
	int getJosephusNumber(int numPeople, int passes, queue<int>& eliminationOrder) {
		queue<int> people;
		for (int i = 1; i <= numPeople; i++) {
			people.push(i);
		}

		while (people.size() > 1) {
			for (int i = 0; i < passes - 1; i++) {
				int passedPerson = people.front();
				people.pop();
				people.push(passedPerson);
			}

			int eliminatedPerson = people.front();
			eliminationOrder.push(eliminatedPerson);
			people.pop();
		}
		return people.front();
	}
};