#include <iostream>
#include <vector>
#include <stack>
#include "Application.h"
using namespace std;

#define neighbours vector<int>

/**
 * Depth-first search
 */
class DFSv2App: public Application {
public:
    void run() {
        vector<neighbours> graph;
        neighbours n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11;

        n1.push_back(1);
        n1.push_back(2);
        n1.push_back(3);
        graph.push_back(n1);

        n2.push_back(0);
        n2.push_back(4);
        n2.push_back(5);
        graph.push_back(n2);

        n3.push_back(0);
        n3.push_back(5);
        n3.push_back(6);
        n3.push_back(7);
        graph.push_back(n3);

        n4.push_back(0);
        n4.push_back(8);
        n4.push_back(9);
        graph.push_back(n4);

        n5.push_back(1);
        n5.push_back(10);
        graph.push_back(n5);

        n6.push_back(1);
        n6.push_back(10);
        graph.push_back(n6);

        n7.push_back(2);
        graph.push_back(n7);

        n8.push_back(2);
        graph.push_back(n8);

        n9.push_back(3);
        graph.push_back(n9);

        n10.push_back(3);
        graph.push_back(n10);

        n11.push_back(4);
        n11.push_back(5);
        graph.push_back(n11);


        dfs(graph, 9);

    }

private:
      void dfs(vector<neighbours> G, int start) {
        stack<int> s;
        int vertexCount = G.size();
        bool *visited = new bool[vertexCount]();
        s.push(start);

        while(!s.empty()) {
            int v = s.top();
            s.pop();
            if (!visited[v]) {
                cout << v << "  ";
                visited[v] = true;
                int neighboursSize = G[v].size();
                for (int i = 0; i < neighboursSize; i++) {
                    s.push(G[v][i]);
                }
            }
        }
      }
};
