#include <iostream>
#include <queue>
#include <stack>
#include <string>
#include "Application.h"
using namespace std;

/*
Demonstrates how to check wether or not a sequence of string objects(phrases) constitute a palindrome(using a stack and a queue). 
We should ignore any characters in the phrases that aren't latin letters. The check is case insensitive
*/

class PalindromeApp : public Application {
public:
	void run() {
		char bulk;
		string* phrases = NULL;
		int numberOfPhrases = 0;
		cout<<"Enter number of phrases: ";
		cin>>numberOfPhrases;
		cin.get(bulk);

		phrases = new string[numberOfPhrases];
		for (int i = 0; i < numberOfPhrases; i++) {
			cout<<"Enter phrase "<<i + 1<<": ";
			getline(cin,phrases[i],'\n');
		}

		if (stringsConsitutePalindrome(phrases, numberOfPhrases)) {
			cout<<endl<<"The phrases you entered constitue a palindrome!!! HOORAY!"<<endl;
		} else {
			cout<<endl<<"Sorry I have to say that, but your phrases... they... they do not constitute a palindrome... *cries and goes away*"<<endl;
		}
	}
private:
	bool stringsConsitutePalindrome(string strings[], int count) {
		stack<char> charStack;
		queue<char> charQueue;
		for (unsigned i = 0; i < count; i++) {
			for (unsigned j = 0; j < strings[i].length(); j++) {
				char currentChar = strings[i][j];
				if ((currentChar <= 'z' && currentChar >= 'a') || (currentChar <= 'Z' && currentChar >= 'A')) {
					charStack.push(currentChar);
					charQueue.push(currentChar);
				}
			}
		}

		while (!charStack.empty() && !charQueue.empty()) {
			char charFromStack = charStack.top(), charFromQueue = charQueue.front();
			if (toupper(charFromStack) != toupper(charFromQueue)) {
				return false;
			}
			charStack.pop();
			charQueue.pop();
		}

		return true;
	}
};