#include <iostream>
#include <queue>
#include "Application.h"
using namespace std;

/**
 * Demonstrates how queue could be sorted using MergeSort algorithm
 */
class QueueMergeSortApp: public Application {

public:
    void run() {
        // init data
        queue<int> q;
        q.push(1);
        q.push(3);
        q.push(7);
        q.push(-1);
        q.push(4);
        q.push(2);

        // merge
        mergeSort(q);

        // print queue
        while (!q.empty()) {
            cout << q.front() << " ";
            q.pop();
        }
    }

private:
    template <class T>
    void mergeSort(queue<T>& q) {
        if (q.size() <= 1) {
            return;
        }

        queue<T> left;
        queue<T> right;

        while (!q.empty()) {
            left.push(q.front());
            q.pop();
            if (!q.empty()) {
                right.push(q.front());
                q.pop();
            }
        }

        mergeSort(left);
        mergeSort(right);
        mergeQueues(left, right, q);
    }

    template <class T>
    void mergeQueues(queue<T>& q1, queue<T>& q2, queue<T>& target) {
        while (!q1.empty() && !q2.empty()) {
            T x = q1.front(),
              y = q2.front();

            if (x <= y) {
                target.push(x);
                q1.pop();
            } else {
                target.push(y);
                q2.pop();
            }
        }

        while (!q1.empty()) {
            target.push(q1.front());
            q1.pop();
        }

        while (!q2.empty()) {
            target.push(q2.front());
            q2.pop();
        }
    }


};
