#include <iostream>
#include <queue>
#include "Application.h"
using namespace std;

/**
 * Sorts a queue using only its own public interface
 */
class WeirdQueueSort: public Application {
public:
    void run() {
        // load data
        queue<int> q;
        q.push(3);
        q.push(1);
        q.push(5);
        q.push(22);
        q.push(-2);
        q.push(23);
        q.push(11);
        q.push(2);
        q.push(10);
        q.push(4);
        q.push(9);
        q.push(8);

        //sort
        weirdSort(q);


        //print
        while (!q.empty()) {
            cout << q.front() << endl;
            q.pop();
        }


    }
private:
    int findMin(queue<int>& q, int border) {
        int size = q.size(),
            i = 0,
            min = q.front(),
            temp;

        while (i < size) {
            temp = q.front();
            q.pop();
            if (min > temp && i < border) {
                min = temp;
            }
            q.push(temp);
            i++;
        }

        return min;
    }

    void reorder(queue<int>& q, int min) {
        int len = q.size(),
            i = 0,
            temp;

        while(i < len) {
            temp = q.front();
            q.pop();
            if (min != temp) { // smell
                q.push(temp);
            }
            i++;
        }
        q.push(min);
    }

    void weirdSort(queue<int>& q) {
        int len = q.size();
        for (int i = 0; i < len; i++) {
            int min = findMin(q, len - i);
            reorder(q, min);
        }
    }


};
