#include "QueueMin.h"
#include <algorithm>

int QueueMin::front() {
	int front = 0;
	if (!popStack.empty()) {
		front = popStack.top();
	} else {
		front = pushStackBottom;
	}
	return front;
}

int QueueMin::back() {
	int back = 0;
	if (!pushStack.empty()) {
		back = pushStack.top();
	} else {
		back = popStackBottom;
	}
	return back;
}

void QueueMin::pop() {
	if (popStack.empty()) {
		popStackBottom = pushStack.top();
		while (!pushStack.empty()) {
			popStack.push(pushStack.top());
			pushStack.pop();
		}
	}
	popStack.pop();
}

bool QueueMin::empty() {
	return pushStack.empty() && popStack.empty();
}

void QueueMin::push(int val) {
	if (pushStack.empty()) {
		pushStackBottom = val;
	}
	pushStack.push(val);
}

int QueueMin::min() {
	int max = 0;
	bool pushEmpty = pushStack.empty(),
		popEmpty = popStack.empty();
	if (pushEmpty && popEmpty) max = -1;
	if (!pushEmpty && !popEmpty) {
		max = std::min(pushStack.min(), popStack.min());
	} else if (!pushEmpty) {
		max = pushStack.min();
	} else {
		max = popStack.min();
	}
	return max;
}
