#include <iostream>
#include <stack>
#include "Application.h"
#include "StackMax.h"
#include "StackMin.h"
#include "QueueMax.h"
#include "QueueMin.h"
#include <queue>

using namespace std;

class StackQueueMaxApplication : public Application {
	void printMinQueueInfo(QueueMin qMin) {
		cout<<"front: "<<qMin.front()<<endl<<"back:  "<<qMin.back()<<endl<<"min:   "<<qMin.min()<<endl;
	}
	void printMaxQueueInfo(QueueMax qMax) {
		cout<<"front: "<<qMax.front()<<endl<<"back:  "<<qMax.back()<<endl<<"max:   "<<qMax.max()<<endl;
	}
	void printMinStackInfo(StackMin stack) {
		cout<<"top: "<<stack.top()<<endl<<"min: "<<stack.min()<<endl;
	}
	void printMaxStackInfo(StackMax stack) {
		cout<<"top: "<<stack.top()<<endl<<"max: "<<stack.max()<<endl;
	}
public:
	void run() {
		//Stack max example
		cout<<"STACK MAX EXAMPLE:"<<endl;
		StackMax maxStack;
		maxStack.push(3);
		maxStack.push(2);
		maxStack.push(5);
		maxStack.push(7);
		maxStack.push(7);
		maxStack.push(1);

		printMaxStackInfo(maxStack);
		maxStack.pop();
		maxStack.pop();
		printMaxStackInfo(maxStack);
		maxStack.pop();
		printMaxStackInfo(maxStack);
		maxStack.pop();
		maxStack.pop();
		printMaxStackInfo(maxStack);
		maxStack.push(6);
		maxStack.push(4);
		printMaxStackInfo(maxStack);
		maxStack.pop();

		//Stack min example
		cout<<"STACK MIN EXAMPLE:"<<endl;
		StackMin minStack;
		minStack.push(3);
		minStack.push(2);
		minStack.push(5);
		minStack.push(7);
		minStack.push(7);
		minStack.push(1);

		printMinStackInfo(minStack);
		minStack.pop();
		minStack.pop();
		printMinStackInfo(minStack);
		minStack.pop();
		printMinStackInfo(minStack);
		minStack.pop();
		minStack.pop();
		printMinStackInfo(minStack);
		minStack.push(6);
		minStack.push(4);
		printMinStackInfo(minStack);
		minStack.pop();

		//Queue min example
		cout<<"QUEUE MIN EXAMPLE:"<<endl;
		QueueMin qMin;
		qMin.push(3);
		printMinQueueInfo(qMin);
		qMin.push(2);
		printMinQueueInfo(qMin);
		qMin.push(5);
		printMinQueueInfo(qMin);
		qMin.push(7);
		printMinQueueInfo(qMin);
		qMin.push(1);
		printMinQueueInfo(qMin);
		qMin.push(1);
		printMinQueueInfo(qMin);
		qMin.pop();
		printMinQueueInfo(qMin);
		qMin.pop();
		printMinQueueInfo(qMin);
		qMin.pop();
		printMinQueueInfo(qMin);
		qMin.pop();
		printMinQueueInfo(qMin);
		qMin.pop();
		printMinQueueInfo(qMin);

		//Queue max examples:
		cout<<"QUEUE MAX EXAMPLE:"<<endl;
		QueueMax qMax;
		qMax.push(3);
		printMaxQueueInfo(qMax);
		qMax.push(2);
		printMaxQueueInfo(qMax);
		qMax.push(5);
		printMaxQueueInfo(qMax);
		qMax.push(7);
		printMaxQueueInfo(qMax);
		qMax.push(1);
		printMaxQueueInfo(qMax);
		qMax.push(1);
		printMaxQueueInfo(qMax);
		qMax.pop();
		printMaxQueueInfo(qMax);
		qMax.pop();
		printMaxQueueInfo(qMax);
		qMax.pop();
		printMaxQueueInfo(qMax);
		qMax.pop();
		printMaxQueueInfo(qMax);
		qMax.pop();
		printMaxQueueInfo(qMax);
	}
};