#pragma once

#include "linked_list.cpp"
using namespace std;

struct PolynomialMember {
	int power;
	float coefficient;
	void operator+=(const PolynomialMember&);
	void operator*=(const PolynomialMember&);
	float operator() (float x);
	PolynomialMember(float, int);
	PolynomialMember();
};

class Polynomial
{
	LinkedList<PolynomialMember> members;
public:
	Polynomial& addMember(const PolynomialMember&);
	
	float operator()(const float x);
	void print();
	void add(const Polynomial&);
	void memberMultiply(const PolynomialMember&);
	void polynomialMultiply(const Polynomial&);
	void divide(const Polynomial, Polynomial& quotient, Polynomial& reminder);
};

