#include "AveragesInserterApp.h"

void AveragesInserterApp::print() {
	LinkedListIterator<float> iterator = floats.begin();
	cout<<"Current version of the list with floats: "<<endl;
	while (iterator) {
		cout<<*iterator<<" ";
		iterator++;
	}
	cout<<endl;
}

void AveragesInserterApp::insertAverages() {
	if (floats.empty()) return;
	LinkedListIterator<float> iteratorPrev, iteratorNext;
	iteratorPrev = iteratorNext = floats.begin();
	iteratorNext++;
	while(iteratorPrev && iteratorNext) {
		float average = ((*iteratorPrev) + (*iteratorNext)) / 2.0f;
		
		iteratorPrev++;
		iteratorNext++;
		
		floats.insertBefore(average,iteratorPrev);
	}
}

void AveragesInserterApp::run() {
	floats.insertEnd(4.0f);
	floats.insertEnd(8.0f);
	//floats.insertEnd(4.0f);

	print();
	insertAverages();
	print();
	insertAverages();
	print();
	insertAverages();
	print();
	insertAverages();
	print();

}