#include <iostream>

#include "ArrayAlgos.h"

using std::cout;
using std::endl;

//        
static void swap(int arr[], unsigned i, unsigned j)
{
	int t = arr[i];
	arr[i] = arr[j];
	arr[j] = t;
}


//    .
//       
void selectionSort(int array[], unsigned size)
{
	for (unsigned i = 0; i < size - 1; ++i)
	{
		int m = minFrom(array, i, size);
		swap(array, m, i);
	}
}


//   .
//     
void insertionSort(int array[], unsigned size)
{
	for (unsigned i = 1; i < size; ++i)
		insertSorted(array, array[i], i);
}


//     
void bubbleSort(int array[], unsigned size)
{
	bool changed = false;       //       
	unsigned sorted = 0;
	do
	{
		changed = false;        // ,    
		//      
		for (unsigned i = size - 1; i > sorted; --i)
		{
			if (array[i] < array[i - 1])      //      
			{
				swap(array, i, i - 1);        //  
				changed = true;             //   
			}
		}
		++sorted;                           //      
	} while (changed);
}


//  
//    X  -1    
int search(int array[], int x, unsigned size)
{
	for (unsigned i = 0; i < size; ++i)
	{
		if (array[i] == x)
			return i;
	}
	return -1;
}


//  .
//    
//    X  -1    
int binarySearch(int array[], int x, unsigned size)
{
	//      
	unsigned left = 0, right = size;

	//       
	while (left < right)
	{
		//  
		unsigned middle = (left + right) / 2;

		if (array[middle] == x)     //    
			return middle;          //   

		if (array[middle] < x)      //     -
			left = middle + 1;      //  
		else
			right = middle;         //   
	}
	return -1;                      //    
}


void findRange(int array[], int x, unsigned size)
{
	unsigned left = 0, right = size;

	while (left < right)
	{
		unsigned middle = (left + right) / 2;

		if (array[middle] < x)
			left = middle + 1;
		else
			right = middle;
	}
	if (array[left] != x)
		return;

	int lb = left;

	right = size;
	while (left < right)
	{
		unsigned middle = (left + right) / 2;
		if (array[middle] <= x)
			left = middle + 1;
		else
			right = middle;
	}
	int rb = left;

	cout << "[" << lb << ", " << rb << "]" << endl;
}
