#include <iostream>
#include "ArrayFunctions.h"

using std::cin;
using std::cout;
using std::cerr;
using std::endl;

//    .       [1, MAX_SIZE]
unsigned readSize()
{
	unsigned n;
	do
	{
		cout << "N= ";
		cin >> n;
	} while (n == 0 || n > MAX_SIZE);
	return n;
}


//     .       size
void readArray(int array[], unsigned size)
{
	for (unsigned i = 0; i < size; ++i)
	{
		cin >> array[i];
	}
}


//     .       size
void printArray(int array[], unsigned size)
{
	for (unsigned i = 0; i < size; ++i)
	{
		cout << array[i] << " ";
	}
	cout << endl;
}


//     .     
int minElement(int array[], unsigned size)
{
	//  
	int min = array[0];
	for (unsigned i = 1; i < size; ++i)
	{
		if (array[i] < min)     //   -
			min = array[i];     //  
	}
	return min;
}


//     .     
unsigned minIndex(int array[], unsigned size)
{
	//  
	unsigned min = 0;
	for (unsigned i = 1; i < size; ++i)
	{
		if (array[i] < array[min])  //   -
			min = i;                //  
	}
	return min;
}


//          size.
//     from.
//    
unsigned minFrom(int array[], unsigned from, unsigned size)
{
	unsigned min = from;
	for (unsigned i = from + 1; i < size; ++i)
	{
		if (array[i] < array[min])
			min = i;
	}
	return min;
}


//      .
//     
//    
unsigned filterNegative(int array[], unsigned size)
{
	unsigned read = 0,  //     
		write = 0; //     
	for (read = 0; read < size; ++read)
	{
		if (array[read] >= 0)
		{
			array[write] = array[read];
			++write;
		}
	}
	return write;
}


//   X   index  .
//     .
//  true      false .
bool insertAt(int array[], unsigned index, int x, unsigned n)
{
	//   
	if (index > n)
	{
		cerr << "Bad position!" << endl;
		return false;
	}

	//        index
	for (unsigned i = n; i > index; i)
		array[i] = array[i - 1];

	//   
	array[index] = x;
	return true;
}


//       index.
//      .
//  true      false .
bool insertAtDirect(int array[], unsigned index, int x, unsigned n)
{
	//   
	if (index > n)
	{
		cerr << "Bad position!" << endl;
		return false;
	}

	array[n] = array[index];
	array[index] = x;
	return true;
}


//       index.
//     .
//  true      false .
bool deleteAt(int array[], unsigned index, unsigned n)
{
	//   
	if (index >= n)
	{
		cerr << "Bad position!" << endl;
		return false;
	}

	//        index
	for (unsigned i = index; i < n - 1; ++i)
		array[i] = array[i + 1];
	return true;
}


//       index.
//      .
//  true      false .
bool deleteAtDirect(int array[], unsigned index, unsigned n)
{
	//   
	if (index > n)
	{
		cerr << "Bad position!" << endl;
		return false;
	}
	array[index] = array[n - 1];
	return true;
}


//       array.
//     ,
void insertSorted(int array[], int x, unsigned size)
{
	int i = size;

	//    -  X     
	while (i > 0 && array[i - 1] > x)
	{
		array[i] = array[i - 1];
		--i;
	}

	//      
	array[i] = x;
}
