package demo
{
 
	import flash.display.Sprite; // To extend this class
 
    import flash.events.Event; // To work out when a frame is entered.
 
    
 
    import org.papervision3d.view.Viewport3D; // We need a viewport
 
    import org.papervision3d.cameras.*; // Import all types of camera
 
    import org.papervision3d.scenes.Scene3D; // We'll need at least one scene
 
    import org.papervision3d.render.BasicRenderEngine; // And we need a renderer
 
    
 
    public class Sample3Dspace extends Sprite { //Must be "extends Sprite"
 
      
 
       public var viewport:Viewport3D; // The Viewport
 
       public var renderer:BasicRenderEngine; // Rendering engine
 
       // -- Scenes -- //
 
       public var default_scene:Scene3D; // A Scene
 
       // -- Cameras --//
 
       public var default_camera:Camera3D; // A Camera
 
      
       public function Sample3Dspace ()
       {
       		init();
       } 
      
 
       public function init(vpWidth:Number = 800, vpHeight:Number = 600):void {
 
         initPapervision(vpWidth, vpHeight); // Initialise papervision
  
         initEvents(); // Set up any event listeners..
 
       }
 
      
 
       protected function initPapervision(vpWidth:Number, vpHeight:Number):void {
 
         // Here is where we initialise everything we need to
 
         // render a papervision scene.
 
         viewport = new Viewport3D(vpWidth, vpHeight);
 
         // The viewport is the object added to the flash scene.
 
         // You 'look at' the papervision scene through the viewport
 
         // window, which is placed on the flash stage.
 
         addChild(viewport); // Add the viewport to the stage.
 
         // Initialise the rendering engine.
 
         renderer = new BasicRenderEngine();
 
         // -- Initialise the Scenes -- //
 
         default_scene = new Scene3D();
 
         // -- Initialise the Cameras -- //
 
         default_camera = new Camera3D(); // The argument passed to the camera
         
 
         // is the object that it should look at. I've passed the scene object
 
         // so that the camera is always pointing at the centre of the scene.
 
       }
 

       protected function initEvents():void {
 
         // This function makes the onFrame function get called for
 
         // every frame.
 
         addEventListener(Event.ENTER_FRAME, onEnterFrame);
 
         // This line of code makes the onEnterFrame function get
 
         // called when every frame is entered.
 
       }
    
 
       protected function onEnterFrame( ThisEvent:Event ):void {
 
			  renderer.renderScene(default_scene, default_camera, viewport);
 
       }
 
      
 
    }
 
    

}