// ActionScript file

import org.papervision3d.core.proto.LightObject3D;
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.lights.PointLight3D;
import org.papervision3d.materials.BitmapMaterial;
import org.papervision3d.materials.WireframeMaterial;
import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
import org.papervision3d.objects.primitives.Sphere;


private function createMaterial (color:Number, alpha:Number=100):MaterialObject3D
{
	
	if (alpha == 0)
	{
		return new WireframeMaterial (color);
	}
	
    return new FlatShadeMaterial (createLight(),0xffffff,color);
}

private var _light:LightObject3D = null;

private function createLight():LightObject3D
{
	
	if (_light != null)
		return _light;
	
	_light = new PointLight3D();        
    _light.x = 0;
    _light.y = 0;
    _light.z = 0;
    
    return _light;
}


   private function createSphere (point:Object, radius:Number,color:Number):Sphere
   {
   	var sphere:Sphere = new Sphere (createMaterial(color), radius,30,30);
   	sphere.x = point.x;
   	sphere.y = point.y;
   	sphere.z = point.z;
   	
   	return sphere;

   }
