#include "Building.h"

#include <cstring>
#include <iostream>

Building::Building(int height, double area, const char* address)
	:address(NULL)
{
	this->setHeight(height);
	this->setArea(area);
	this->setAddress(address);
}

Building::Building(const Building& other)
	:Building(other.height, other.area, other.address)
{}


Building& Building::operator=(const Building& other)
{
	if (this != &other)
	{
		this->setHeight(other.height);
		this->setArea(other.area);
		this->setAddress(other.address);
	}

	return *this;
}

Building::~Building()
{
	delete[] this->address;
}

void Building::setHeight(int height)
{
	if (height < 0)
		throw "Invalid value for height!";

	this->height = height;
}

void Building::setArea(double area)
{
	if (area < 0)
		throw "Invalid value for area!";

	this->area = area;
}

void Building::setAddress(const char* address)
{
	if (!address) address = "";

	delete[] this->address;

	size_t len = strlen(address) + 1;
	this->address = new char[len];
	strcpy_s(this->address, len, address);
}

void Building::print() const
{
	this->printTitle();
	this->printOwnDetails();
}

void Building::printTitle() const
{
	std::cout << "Building" << std::endl;
}

void Building::printOwnDetails() const
{
	std::cout << "Height: " << this->height << '\n'
		<< "Area: " << this->area << '\n'
		<< "Address: " << this->address << std::endl;
}