#include "House.h"

#include <iostream>

House::House(int height, double area, const char* address, int floors, const char* owner)
	:Building(height, area, address), owner(NULL)
{
	this->setFloors(floors);
	this->setOwner(owner);
}

House::House(const House& other)
	:Building(other), owner(NULL)
{
	this->setFloors(other.countFloors);
	this->setOwner(other.owner);
}

House& House::operator=(const House& other)
{
	if (this != &other)
	{
		Building::operator=(other);

		this->setFloors(other.countFloors);
		this->setOwner(other.owner);
	}

	return *this;
}

House::~House()
{
	delete[] this->owner;
}

void House::setFloors(int floors)
{
	if (floors < 0)
		throw "Invalid value for count floors!";

	this->countFloors = floors;
}

void House::setOwner(const char* owner)
{
	if (!owner)
		owner = "";

	delete[] this->owner;

	size_t len = strlen(owner) + 1;
	this->owner = new char[len];
	strcpy_s(this->owner, len, owner);
}

void House::printTitle() const
{
	std::cout << "House" << std::endl;
}

void House::printOwnDetails() const
{
	Building::printOwnDetails();
	std::cout << "Floors: " << this->countFloors << std::endl;
	std::cout << "Owner: " << this->owner << std::endl;
}